﻿---
title: SyncGateway module
description: Sync Gateway is the synchronization server in a Couchbase for Mobile and Edge deployment. This metricset allows to monitor a Sync Gateway instance by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-syncgateway
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# SyncGateway module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Sync Gateway is the synchronization server in a Couchbase for Mobile and Edge deployment. This metricset allows to monitor a Sync Gateway instance by using its REST API.
Sync Gateway access `[host]:[port]/_expvar` on Sync Gateway nodes to fetch metrics data, ensure that the URL is accessible from the host where Metricbeat is running.

## Example configuration

The SyncGateway module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: syncgateway
  metricsets:
    - db
#    - memory
#    - replication
#    - resources
  period: 10s

  # SyncGateway hosts
  hosts: ["127.0.0.1:4985"]
```


## Metricsets

The following metricsets are available:
- [db](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-syncgateway-db)  <applies-to>Elastic Stack: Beta</applies-to>
- [memory](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-syncgateway-memory)  <applies-to>Elastic Stack: Beta</applies-to>
- [replication](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-syncgateway-replication)  <applies-to>Elastic Stack: Beta</applies-to>
- [resources](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-syncgateway-resources)  <applies-to>Elastic Stack: Beta</applies-to>