﻿---
title: Statsd module
description: The statsd module is a Metricbeat module which spawns a UDP server and listens for metrics in StatsD compatible format. The module supports the following...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-statsd
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Statsd module
The `statsd` module is a Metricbeat module which spawns a UDP server and listens for metrics in StatsD compatible format.

## Metric types

The module supports the following types of metrics:
<definitions>
  <definition term="Counter (c)">
    Measurement which accumulates over period of time until flushed (value set to 0).
  </definition>
  <definition term="Gauge (g)">
    Measurement which can increase, decrease or be set to a value.
  </definition>
  <definition term="Timer (ms)">
    Time measurement (in milliseconds) of an event.
  </definition>
  <definition term="Histogram (h)">
    Time measurement, alias for timer.
  </definition>
  <definition term="Set (s)">
    Measurement which counts unique occurrences until flushed (value set to 0).
  </definition>
</definitions>


## Supported tag extensions

Example of tag styles supported by the `statsd` module:
[DogStatsD](https://docs.datadoghq.com/developers/dogstatsd/datagram_shell/?tab=metrics#the-dogstatsd-protocol)
`<metric name>:<value>|<type>|@samplerate|#<k>:<v>,<k>:<v>`
[InfluxDB](https://github.com/influxdata/telegraf/blob/master/plugins/inputs/statsd/README.md#influx-statsd)
`<metric name>,<k>=<v>,<k>=<v>:<value>|<type>|@samplerate`
[Graphite_1.1.x](https://graphite.readthedocs.io/en/latest/tags.html#graphite-tag-support)
`<metric name>;<k>=<v>;<k>=<v>:<value>|<type>|@samplerate`

## Module-specific configuration notes

The `statsd` module has these additional config options:
<definitions>
  <definition term="ttl">
    It defines how long a metric will be reported after it was last recorded. Irrespective of the given ttl, metrics will be reported at least once. A ttl of zero means metrics will never expire.
  </definition>
  <definition term="statsd.mappings">
    It defines how metrics will mapped from the original metric label to the event json. Here’s an example configuration:
  </definition>
</definitions>

```yaml
statsd.mappings:
  - metric: 'ti_failures' 
    value:
      field: task_failures 
  - metric: '<job_name>_start' 
    labels:
      - attr: job_name 
        field: job_name 
    value:
      field: started 
```


## Example configuration

The Statsd module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: statsd
  host: "localhost"
  port: "8125"
  enabled: false
  #ttl: "30s"
```


## Metricsets

The following metricsets are available:
- [server](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-statsd-server)