﻿---
title: Stan module
description: The STAN module uses STAN monitoring server APIs to collect metrics. The default metricsets are channels, stats and subscriptions. The STAN module is...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-stan
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Stan module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/stan).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The STAN module uses [STAN monitoring server APIs](https://github.com/nats-io/nats-streaming-server/blob/master/server/monitor.go) to collect metrics.
The default metricsets are `channels`, `stats` and `subscriptions`.

### Compatibility

The STAN module is tested with STAN 0.15.1.

## Dashboard

Dashboards for topic message count and queue depth are included:
![metricbeat stan overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-stan-overview.png)

## Example configuration

The Stan module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: stan
  metricsets: ["stats", "channels", "subscriptions"]
  period: 60s
  hosts: ["localhost:8222"]
  #stats.metrics_path: "/streaming/serverz"
  #channels.metrics_path: "/streaming/channelsz"
  #subscriptions.metrics_path: "/streaming/channelsz"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [channels](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-stan-channels)
- [stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-stan-stats)
- [subscriptions](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-stan-subscriptions)