﻿---
title: Redis Enterprise module
description: This module periodically fetches metrics from Redis Enterprise Software. The defaut metricsets are node and proxy. The redisenterprise module has these...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-redisenterprise
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Redis Enterprise module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This module periodically fetches metrics from [Redis Enterprise Software](https://redislabs.com/redis-enterprise/).
The defaut metricsets are `node` and `proxy`.

## Module-specific configuration notes

The `redisenterprise` module has these additional config options:
<definitions>
  <definition term="hosts">
    URLs that are used to connect to Redis. URL format: `https://HOST:PORT`
  </definition>
</definitions>


## Compatibility

The metricsets `node` and `proxy` are compatible with Redis Enterprise Software (RES). There were tested with RES 5.4.10-22 and are expected to work with all versions >= 5.0.2.

## Dashboard

The `redisenterprise` module includes a predefined dashboard with overview information of the monitored servers.
![metricbeat redisenterprise overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-redisenterprise-overview.png)

## Example configuration

The Redis Enterprise module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: redisenterprise
  metricsets:
    - node
    - proxy
  period: 1m

  # Metrics endpoint
  hosts: ["https://127.0.0.1:8070/"]
```


## Metricsets

The following metricsets are available:
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-redisenterprise-node)  <applies-to>Elastic Stack: Beta</applies-to>
- [proxy](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-redisenterprise-proxy)  <applies-to>Elastic Stack: Beta</applies-to>