﻿---
title: RabbitMQ module
description: The RabbitMQ module uses HTTP API created by the management plugin to collect metrics. The default metricsets are connection, node, queue, exchange and...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-rabbitmq
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# RabbitMQ module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/rabbitmq).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The RabbitMQ module uses [HTTP API](http://www.rabbitmq.com/management.html) created by the management plugin to collect metrics.
The default metricsets are `connection`, `node`, `queue`, `exchange` and `shovel`.
If `management.path_prefix` is set in RabbitMQ configuration, `management_path_prefix` has to be set to the same value in this module configuration.

## Compatibility

The rabbitmq module is fully tested with RabbitMQ 3.7.4 and it should be compatible with any version supporting the management plugin (which needs to be installed and enabled). Exchange metricset is also tested with 3.6.0, 3.6.5 and 3.7.14

## Example configuration

The RabbitMQ module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: rabbitmq
  metricsets: ["node", "queue", "connection", "exchange", "shovel"]
  enabled: true
  period: 10s
  hosts: ["localhost:15672"]

  # Management path prefix, if `management.path_prefix` is set in RabbitMQ
  # configuration, it has to be set to the same value.
  #management_path_prefix: ""

  #username: guest
  #password: guest
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [connection](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-connection)
- [exchange](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-exchange)
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-node)
- [queue](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-queue)
- [shovel](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-shovel)  <applies-to>Elastic Stack: Beta</applies-to>