﻿---
title: PHP_FPM module
description: This module periodically fetches metrics from PHP-FPM servers. The default metricset is pool. You need to enable the PHP-FPM status page by properly configuring...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-php_fpm
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# PHP_FPM module
This module periodically fetches metrics from [PHP-FPM](https://php-fpm.org) servers.
The default metricset is `pool`.

## Module-specific configuration notes

You need to enable the PHP-FPM status page by properly configuring `pm.status_path`.
Here is a sample nginx configuration to forward requests to the PHP-FPM status page (assuming `pm.status_path` is configured with default value `/status`):
```
nginx
location ~ /status {
     allow 127.0.0.1;
     deny all;
     include fastcgi_params;
     fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
     fastcgi_pass 127.0.0.1:9000;
}
```


## Compatibility

The PHP_FPM metricsets were tested with PHP 7.1.1 and are expected to work with all versions >= 5.

## Example configuration

The PHP_FPM module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: php_fpm
  metricsets:
  - pool
  #- process
  enabled: true
  period: 10s
  status_path: "/status"
  hosts: ["localhost:8080"]
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [pool](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-php_fpm-pool)
- [process](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-php_fpm-process)