﻿---
title: Nginx module
description: This module periodically fetches metrics from Nginx servers. The default metricset is stubstatus. The Nginx metricsets were tested with Nginx 1.23.2 and...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-nginx
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Nginx module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/nginx).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches metrics from [Nginx](https://nginx.org/) servers.
The default metricset is `stubstatus`.

## Compatibility

The Nginx metricsets were tested with Nginx 1.23.2 and are expected to work with all version >= 1.9.

## Dashboard

The nginx module comes with a predefined dashboard. For example:
![metricbeat nginx](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-nginx.png)

## Example configuration

The Nginx module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: nginx
  metricsets: ["stubstatus"]
  enabled: true
  period: 10s

  # Nginx hosts
  hosts: ["http://127.0.0.1"]

  # Path to server status. Default nginx_status
  server_status_path: "nginx_status"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [stubstatus](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nginx-stubstatus)