﻿---
title: NATS module
description: The Nats module uses Nats monitoring server APIs to collect metrics. The default metricsets are stats, connections, routes and subscriptions. The connection,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-nats
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# NATS module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/nats).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The Nats module uses [Nats monitoring server APIs](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring) to collect metrics.
The default metricsets are `stats`, `connections`, `routes` and `subscriptions`. The `connection`, `route`, and `jetstream` metricsets can be enabled to collect additional metrics.

## Compatibility

The NATS module is tested with NATS 2.2.6 and 2.11.x. Versions in between are expected to be compatible as well.

## Dashboard

The Nats module comes with a predefined dashboard. For example:
![metricbeat nats dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat_nats_dashboard.png)

## Example configuration

The NATS module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: nats
  metricsets:
    - "connections"
    - "routes"
    - "stats"
    - "subscriptions"
    #- "connection"
    #- "route"
    #- "jetstream"
  period: 10s
  hosts: ["localhost:8222"]
  #stats.metrics_path: "/varz"
  #connections.metrics_path: "/connz"
  #routes.metrics_path: "/routez"
  #subscriptions.metrics_path: "/subsz"
  #connection.metrics_path: "/connz"
  #route.metrics_path: "/routez"
  #jetstream:
  #  stats:
  #    enabled: true
  #  account:
  #    enabled: true
  #    names:
  #      - default
  #  stream:
  #    enabled: true
  #    names:
  #      - my-stream-1
  #      - another-stream
  #  consumer:
  #    enabled: true
  #    names:
  #      - my-stream-1-consumer-1
  #      - my-stream-1-consumer-2
  #      - another-stream-consumer-1
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [connection](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-connection)
- [connections](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-connections)
- [jetstream](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-jetstream)  <applies-to>Elastic Stack: Beta since 9.1</applies-to>
- [route](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-route)
- [routes](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-routes)
- [stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-stats)
- [subscriptions](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-subscriptions)