﻿---
title: MySQL module
description: This module periodically fetches metrics from MySQL servers. The default metricset is status. When configuring the hosts option, you must use a MySQL...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mysql
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MySQL module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/mysql).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches metrics from [MySQL](https://www.mysql.com/) servers.
The default metricset is `status`.

## Module-specific configuration notes

When configuring the `hosts` option, you must use a MySQL Data Source Name (DSN) of the following format:
```
[username[:password]@][protocol[(address)]]/
```

You can also separately specify the username and password using the respective configuration options. Usernames and passwords specified in the DSN take precedence over those specified in the `username` and `password` config options.
```
- module: mysql
  metricsets: ["status"]
  hosts: ["tcp(127.0.0.1:3306)/"]
  username: root
  password: secret
```


## Compatibility

The mysql MetricSets were tested with MySQL and Percona 5.7 and 8.0 and are expected to work with all versions >= 5.7.0. It is also tested with MariaDB 10.2, 10.3 and 10.4.

## Dashboard

The mysql module comes with a predefined dashboard. For example:
![metricbeat mysql](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-mysql.png)

## Example configuration

The MySQL module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: mysql
  metricsets:
    - status
  #  - galera_status
  #  - performance
  #  - query
  period: 10s

  # Host DSN should be defined as "user:pass@tcp(127.0.0.1:3306)/"
  # or "unix(/var/lib/mysql/mysql.sock)/",
  # or another DSN format supported by <https://github.com/Go-SQL-Driver/MySQL/>.
  # The username and password can either be set in the DSN or using the username
  # and password config options. Those specified in the DSN take precedence.
  hosts: ["root:secret@tcp(127.0.0.1:3306)/"]

  # Username of hosts. Empty by default.
  #username: root

  # Password of hosts. Empty by default.
  #password: secret

  # By setting raw to true, all raw fields from the status metricset will be added to the event.
  #raw: false

  # Optional SSL/TLS. By default is false.
  #ssl.enabled: true

  # List of root certificates for SSL/TLS server verification
  #ssl.certificate_authorities: ["/etc/pki/root/ca.crt"]

  # Certificate for SSL/TLS client authentication
  #ssl.certificate: "/etc/pki/client/cert.crt"

  # Client certificate key file
  #ssl.key: "/etc/pki/client/cert.key"
```


## Metricsets

The following metricsets are available:
- [galera_status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-galera_status)  <applies-to>Elastic Stack: Beta</applies-to>
- [performance](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-performance)  <applies-to>Elastic Stack: Beta</applies-to>
- [query](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-query)  <applies-to>Elastic Stack: Beta</applies-to>
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-status)