﻿---
title: Munin module
description: This is the munin module. The default metricset is node. Munin module should be compatible with any implementation of the munin network protocol (http://guide.munin-monitoring.org/en/latest/master/network-protocol.html),...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-munin
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Munin module
This is the munin module.
The default metricset is `node`.

## Compatibility

Munin module should be compatible with any implementation of the munin network protocol ([http://guide.munin-monitoring.org/en/latest/master/network-protocol.html](http://guide.munin-monitoring.org/en/latest/master/network-protocol.html)), it is tested with munin node 2.0.

## Example configuration

The Munin module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: munin
  metricsets: ["node"]
  enabled: true
  period: 10s
  hosts: ["localhost:4949"]

  # List of plugins to collect metrics from, by default it collects from
  # all the available ones.
  #munin.plugins: []

  # If set to true, it sanitizes fields names in concordance with munin
  # implementation (all characters that are not alphanumeric, or underscore
  # are replaced by underscores).
  #munin.sanitize: false
```


## Metricsets

The following metricsets are available:
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-munin-node)