﻿---
title: MSSQL module
description: This is the Microsoft SQL 2017 Metricbeat module. It is still under active development to add new Metricsets and introduce enhancements. The module is...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mssql
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MSSQL module
This is the [Microsoft SQL 2017](https://www.microsoft.com/en-us/sql-server/sql-server-2017) Metricbeat module. It is still under active development to add new Metricsets and introduce enhancements.

## Compatibility

The module is being tested with [2017 GA](https://hub.docker.com/r/microsoft/mssql-server-linux/) version under Linux

## Permission/Access required for tables

1.`transaction_log` :
- sys.databases
- sys.dm_db_log_space_usage
- sys.dm_db_log_stats(DB_ID)

2.`performance` :
- sys.dm_os_performance_counters

If you browse MSDN for above tables, you will find "Permissions" section which defines the permission needed, e.g [Permissions](https://docs.microsoft.com/en-us/sql/relational-databases/system-dynamic-management-views/sys-dm-db-log-space-usage-transact-sql?view=sql-server-ver15)

## Metricsets

The following Metricsets are already included:

### `transaction_log`

`transaction_log` Metricset fetches information about the operation and transaction log of each MSSQL database in the monitored instance. All data is extracted from the [Database Dynamic Management Views](https://docs.microsoft.com/en-us/sql/relational-databases/system-dynamic-management-views/database-related-dynamic-management-views-transact-sql?view=sql-server-2017)

### `performance`

`performance` Metricset fetches information from what’s commonly known as [Performance Counters](https://docs.microsoft.com/en-us/sql/relational-databases/system-dynamic-management-views/sys-dm-os-performance-counters-transact-sql?view=sql-server-2017) in MSSQL.

## Module-specific configuration notes

When configuring the `hosts` option, you can specify native user credentials as part of the host string with the following format:
```
hosts: ["sqlserver://sa@localhost"]
```

To use Active Directory domain credentials, you can separately specify the username and password using the respective configuration options to allow the domain to be included in the username:
```
metricbeat.modules:
- module: mssql
  metricsets:
    - "transaction_log"
    - "performance"
  hosts: ["sqlserver://localhost"]
  username: domain\username
  password: verysecurepassword
  period: 10
```

Store sensitive values like passwords in the [secrets keystore](https://www.elastic.co/docs/reference/beats/metricbeat/keystore).

## Example configuration

The MSSQL module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: mssql
  metricsets:
    - "transaction_log"
    - "performance"
  hosts: ["sqlserver://localhost"]
  username: domain\username
  password: verysecurepassword
  period: 10s
```


## Metricsets

The following metricsets are available:
- [performance](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mssql-performance)
- [transaction_log](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mssql-transaction_log)