﻿---
title: Logstash module
description: The logstash module collects metrics about Logstash. The logstash module works with Logstash 7.3.0 and later. The logstash module can be used to collect...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-logstash
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Logstash module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/logstash).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The `logstash` module collects metrics about Logstash.

## Compatibility

The `logstash` module works with Logstash 7.3.0 and later.

## Usage for Stack Monitoring

The `logstash` module can be used to collect metrics shown in our Stack Monitoring UI in Kibana. To enable this usage, set `xpack.enabled: true` and remove any `metricsets` from the module’s configuration. Alternatively, run `metricbeat modules disable logstash` and `metricbeat modules enable logstash-xpack`.
<note>
  When this module is used for Elastic Stack Monitoring, it sends metrics to the monitoring index instead of the default index typically used by Metricbeat. For more details about the monitoring index, see [Configuring indices for monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring).
</note>


## Example configuration

The Logstash module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: logstash
  metricsets: ["node", "node_stats"]
  enabled: true
  period: 10s
  hosts: ["localhost:9600"]
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-logstash-node)
- [node_stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-logstash-node_stats)