﻿---
title: Linux module
description: The Linux module reports on metrics exclusive to the Linux kernel and GNU/Linux OS. The Linux module supports the standard configuration options that...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-linux
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/linux).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The Linux module reports on metrics exclusive to the Linux kernel and GNU/Linux OS.

## Example configuration

The Linux module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: linux
  period: 10s
  metricsets:
    - "pageinfo"
    - "memory"
    # - ksm
    # - conntrack
    # - iostat
    # - pressure
    # - rapl
  enabled: true
  #hostfs: /hostfs
  #rapl.use_msr_safe: false
```


## Metricsets

The following metricsets are available:
- [conntrack](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-conntrack)  <applies-to>Elastic Stack: Beta</applies-to>
- [iostat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-iostat)  <applies-to>Elastic Stack: Beta</applies-to>
- [ksm](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-ksm)  <applies-to>Elastic Stack: Beta</applies-to>
- [memory](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-memory)  <applies-to>Elastic Stack: Beta</applies-to>
- [pageinfo](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-pageinfo)  <applies-to>Elastic Stack: Beta</applies-to>
- [pressure](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-pressure)  <applies-to>Elastic Stack: Beta</applies-to>
- [rapl](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-rapl)  <applies-to>Elastic Stack: Beta</applies-to>