﻿---
title: KVM module
description: This is the kvm module. The KVM module supports the standard configuration options that are described in Modules. Here is an example configuration: The...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kvm
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# KVM module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the kvm module.

## Example configuration

The KVM module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: kvm
  metricsets: ["dommemstat", "status"]
  enabled: true
  period: 10s
  hosts: ["unix:///var/run/libvirt/libvirt-sock"]
  # For remote hosts, setup network access in libvirtd.conf
  # and use the tcp scheme:
  # hosts: [ "tcp://<host>:16509" ]

  # Timeout to connect to Libvirt server
  #timeout: 1s
```


## Metricsets

The following metricsets are available:
- [dommemstat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kvm-dommemstat)  <applies-to>Elastic Stack: Beta</applies-to>
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kvm-status)  <applies-to>Elastic Stack: Beta</applies-to>