﻿---
title: Kibana module
description: The kibana module collects metrics about Kibana. The kibana module works with Kibana 6.7.0 and later. The kibana module can be used to collect metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kibana
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kibana module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/kibana).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The `kibana` module collects metrics about Kibana.

## Compatibility

The `kibana` module works with Kibana 6.7.0 and later.

## Usage for Elastic Stack Monitoring

The `kibana` module can be used to collect metrics shown in our Stack Monitoring UI in Kibana. To enable this usage, set `xpack.enabled: true` and remove any `metricsets` from the module’s configuration. Alternatively, run `metricbeat modules disable kibana` and `metricbeat modules enable kibana-xpack`.
<note>
  When this module is used for Elastic Stack Monitoring, it sends metrics to the monitoring index instead of the default index typically used by Metricbeat. For more details about the monitoring index, see [Configuring indices for monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring).
</note>


## Example configuration

The Kibana module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: kibana
  metricsets: ["status"]
  period: 10s
  hosts: ["localhost:5601"]
  basepath: ""
  enabled: true
  #username: "user"
  #password: "secret"
  #api_key: "foo:bar"

  # Set to true to send data collected by module to X-Pack
  # Monitoring instead of metricbeat-* indices.
  #xpack.enabled: false
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [cluster_actions](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-cluster_actions)  <applies-to>Elastic Stack: Beta</applies-to>
- [cluster_rules](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-cluster_rules)  <applies-to>Elastic Stack: Beta</applies-to>
- [node_actions](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-node_actions)  <applies-to>Elastic Stack: Beta</applies-to>
- [node_rules](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-node_rules)  <applies-to>Elastic Stack: Beta</applies-to>
- [stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-stats)
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-status)