﻿---
title: HAProxy module
description: This module collects stats from HAProxy. It supports collection from TCP sockets, UNIX sockets, or HTTP with or without basic authentication. Metricbeat...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-haproxy
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# HAProxy module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/haproxy).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module collects stats from [HAProxy](http://www.haproxy.org/). It supports collection from TCP sockets, UNIX sockets, or HTTP with or without basic authentication.
Metricbeat can collect two metricsets from HAProxy: `info` and `stat`. `info` is not available when using the stats page.

## Configure HAProxy to collect stats

Before you can use Metricbeat to collect stats, you must enable the stats module in HAProxy. You can do this a couple of ways: configure HAProxy to report stats via a TCP or UNIX socket, or enable the stats page.

### TCP socket

To enable stats reporting via any local IP on port 14567, add the following line to the `global` or `default` section of the HAProxy config:
```shell
 stats socket 127.0.0.1:14567
```

<note>
  You should use an internal private IP, or secure this with a firewall rule, so that only designated hosts can access this data.
</note>


### UNIX socket

To enable stats reporting via a UNIX socket, add the following line to the `global` or `default` section of the HAProxy config:
```shell
 stats socket /path/to/haproxy.sock mode 660 level admin
```


### Stats page

To enable the HAProxy stats page, add the following lines to the HAProxy config, then restart HAProxy. The stats page in this example will be available to any IP on port 14567 after authentication.
```text
 listen stats
   bind 0.0.0.0:14567
   stats enable
   stats uri /stats
   stats auth admin:admin
```


## Compatibility

The HAProxy metricsets are tested with HAProxy versions from 1.6 to 1.8.

## Example configuration

The HAProxy module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: haproxy
  metricsets: ["info", "stat"]
  period: 10s
  # TCP socket, UNIX socket, or HTTP address where HAProxy stats are reported
  # TCP socket
  hosts: ["tcp://127.0.0.1:14567"]
  # UNIX socket
  #hosts: ["unix:///path/to/haproxy.sock"]
  # Stats page
  #hosts: ["http://127.0.0.1:14567"]
  username : "admin"
  password : "admin"
  enabled: true
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [info](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-haproxy-info)
- [stat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-haproxy-stat)