﻿---
title: Graphite module
description: This is the Graphite module. The default metricset is server. The Graphite module supports the standard configuration options that are described in Modules...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-graphite
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Graphite module
This is the Graphite module.
The default metricset is `server`.

## Example configuration

The Graphite module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: graphite
  metricsets: ["server"]
  enabled: true

  # Host address to listen on. Default localhost.
  #host: localhost

  # Listening port. Default 2003.
  #port: 2003

  # Protocol to listen on. This can be udp or tcp. Default udp.
  #protocol: "udp"

  # Receive buffer size in bytes
  #receive_buffer_size: 1024

  #templates:
  #  - filter: "test.*.bash.*"
  #    namespace: "test"
  #    template: ".host.shell.metric*"
  #    delimiter: "_"
```


## Metricsets

The following metricsets are available:
- [server](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-graphite-server)