﻿---
title: Golang module
description: The golang module collects metrics by submitting HTTP GET requests to golang-expvar-api. The Golang module supports the standard configuration options...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-golang
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Golang module
The golang module collects metrics by submitting HTTP GET requests to [golang-expvar-api](https://golang.org/pkg/expvar/).

## Example configuration

The Golang module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: golang
  #metricsets:
  #  - expvar
  #  - heap
  period: 10s
  hosts: ["localhost:6060"]
  heap.path: "/debug/vars"
  expvar:
    namespace: "example"
    path: "/debug/vars"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [expvar](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-golang-expvar)
- [heap](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-golang-heap)