﻿---
title: Etcd module
description: This module targets Etcd V2 and V3. When using V2, metrics are collected using Etcd v2 API. When using V3, metrics are retrieved from the /metrics endpoint...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-etcd
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Etcd module
This module targets Etcd V2 and V3.
When using V2, metrics are collected using [Etcd v2 API](https://coreos.com/etcd/docs/latest/v2/api.md). When using V3, metrics are retrieved from the `/metrics` endpoint as intended for [Etcd v3](https://coreos.com/etcd/docs/latest/metrics.md)
When using V3, metricsest are bundled into `metrics` When using V2, metricsets available are `leader`, `self` and `store`.

## Compatibility

The etcd module is tested with etcd 3.2 and 3.3.

## Example configuration

The Etcd module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: etcd
  metricsets: ["leader", "self", "store"]
  period: 10s
  hosts: ["localhost:2379"]
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [leader](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-etcd-leader)
- [metrics](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-etcd-metrics)  <applies-to>Elastic Stack: Beta</applies-to>
- [self](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-etcd-self)
- [store](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-etcd-store)