﻿---
title: Elasticsearch module
description: The elasticsearch module collects metrics about Elasticsearch. The elasticsearch module works with Elasticsearch 6.7.0 and later. The elasticsearch module...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-elasticsearch
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/elasticsearch).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

The `elasticsearch` module collects metrics about Elasticsearch.

## Compatibility

The `elasticsearch` module works with Elasticsearch 6.7.0 and later.

## Usage for Elastic Stack Monitoring

The `elasticsearch` module can be used to collect metrics shown in our Stack Monitoring UI in Kibana. To enable this usage, set `xpack.enabled: true` and remove any `metricsets` from the module’s configuration. Alternatively, run `metricbeat modules disable elasticsearch` and `metricbeat modules enable elasticsearch-xpack`.
When xpack mode is enabled, all the legacy metricsets are automatically enabled by default. This means that you do not need to manually enable them, and there will be no conflicts or issues because Metricbeat merges the user-defined metricsets with the ones that xpack mode forces to enable. As a result, you can seamlessly collect comprehensive metrics without worrying about dataset overlap or duplication.
```yaml
metricbeat.modules:
- module: elasticsearch
  xpack.enabled: true
  metricsets:
    - ingest_pipeline
  period: 10s
```

<note>
  When this module is used for Elastic Stack Monitoring, it sends metrics to the monitoring index instead of the default index typically used by Metricbeat. For more details about the monitoring index, see [Configuring indices for monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring).
</note>


## Module-specific configuration notes

Like other Metricbeat modules, the `elasticsearch` module accepts a `hosts` configuration setting. This setting can contain a list of entries. The related `scope` setting determines how each entry in the `hosts` list is interpreted by the module.
- If `scope` is set to `node` (default), each entry in the `hosts` list indicates a distinct node in an Elasticsearch cluster.
- If `scope` is set to `cluster`, each entry in the `hosts` list indicates a single endpoint for a distinct Elasticsearch cluster (for example, a load-balancing proxy fronting the cluster).

Also like some other modules, the `elasticsearch` module accepts either a `username`/`password` pair of settings or a single `api_key` setting. You cannot specify the `username`/`password` settings _and_ `api_key` at the same time.
When used, the `api_key`  configuration can be specified as:
- <applies-to>Elastic Stack: Generally available since 9.1</applies-to> The unencoded `id:api_key` format (`api_key: "foo:bar"`) or the Base64-encoded `id:api_key` format (`api_key: "Zm9vOmJhcgo="`).
- All earlier releases can only use the unencoded `id:api_key` format (`api_key: "foo:bar"`).


## Example configuration

The Elasticsearch module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: elasticsearch
  metricsets:
    - node
    - node_stats
    #- index
    #- index_recovery
    #- index_summary
    #- ingest_pipeline
    #- shard
    #- ml_job
  period: 10s
  hosts: ["http://localhost:9200"]
  #username: "elastic"
  #password: "changeme"
  #api_key: "foo:bar"
  #ssl.certificate_authorities: ["/etc/pki/root/ca.pem"]

  #index_recovery.active_only: true
  #ingest_pipeline.processor_sample_rate: 0.25
  #xpack.enabled: false
  #scope: node
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [ccr](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-ccr)
- [cluster_stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-cluster_stats)
- [enrich](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-enrich)
- [index](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-index)
- [index_recovery](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-index_recovery)
- [index_summary](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-index_summary)
- [ingest_pipeline](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-ingest_pipeline)  <applies-to>Elastic Stack: Beta</applies-to>
- [ml_job](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-ml_job)
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-node)
- [node_stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-node_stats)
- [pending_tasks](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-pending_tasks)
- [shard](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-shard)