﻿---
title: Dropwizard module
description: This is the Dropwizard module. The default metricset is collector. The Dropwizard module is tested with dropwizard metrics 3.2.6, 4.0.0 and 4.1.2. The...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-dropwizard
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Dropwizard module
This is the [Dropwizard](http://dropwizard.io) module. The default metricset is `collector`.

## Compatibility

The Dropwizard module is tested with dropwizard metrics 3.2.6, 4.0.0 and 4.1.2.

## Example configuration

The Dropwizard module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: dropwizard
  metricsets: ["collector"]
  period: 10s
  hosts: ["localhost:8080"]
  metrics_path: /metrics/metrics
  namespace: example
  enabled: true
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [collector](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-dropwizard-collector)