﻿---
title: Docker module
description: This module fetches metrics from Docker containers. The default metricsets are: container, cpu, diskio, healthcheck, info, memory and network. The image...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-docker
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Docker module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/docker).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module fetches metrics from [Docker](https://www.docker.com/) containers. The default metricsets are: `container`, `cpu`, `diskio`, `healthcheck`, `info`, `memory` and `network`. The `image` metricset is not enabled by default.

## Compatibility

The Docker module is currently tested on Linux and Mac with the community edition engine, versions 1.11 and 17.09.0-ce. It is not tested on Windows, but it should also work there.
The Docker module supports collection of metrics from Podman’s Docker-compatible API on Metricbeat 8.16.2 and 8.17.1, and higher versions. It has been tested on Linux and Mac with Podman Rest API v2.0.0 and above.

## Module-specific configuration notes

It is strongly recommended that you run Docker metricsets with a [`period`](/docs/reference/beats/metricbeat/configuration-metricbeat#metricset-period) that is 3 seconds or longer. The request to the Docker API already takes up to 2 seconds. Specifying less than 3 seconds will result in requests that timeout, and no data will be reported for those requests. In the case of Podman, the configuration parameter `podman` should be set to `true`. This enables streaming of container stats output, which allows for more accurate CPU percentage calculations when using Podman.

## Example configuration

The Docker module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: docker
  metricsets:
    - "container"
    - "cpu"
    - "diskio"
    - "event"
    - "healthcheck"
    - "info"
    #- "image"
    - "memory"
    - "network"
    #- "network_summary"
  hosts: ["unix:///var/run/docker.sock"]
  period: 10s
  enabled: true

  # If set to true, replace dots in labels with `_`.
  #labels.dedot: false

  # Docker module supports metrics collection from podman's docker compatible API. In case of podman set to true.
  # podman: false

  # Skip metrics for certain device major numbers in docker/diskio. 
  # Necessary on systems with software RAID, device mappers, 
  # or other configurations where virtual disks will sum metrics from other disks.
  # By default, it will skip devices with major numbers 9 or 253.
  #skip_major: []

  # If set to true, collects metrics per core.
  #cpu.cores: true

  # To connect to Docker over TLS you must specify a client and CA certificate.
  #ssl:
    #certificate_authority: "/etc/pki/root/ca.pem"
    #certificate:           "/etc/pki/client/cert.pem"
    #key:                   "/etc/pki/client/cert.key"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl).

## Metricsets

The following metricsets are available:
- [container](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-container)
- [cpu](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-cpu)
- [diskio](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-diskio)
- [event](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-event)
- [healthcheck](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-healthcheck)
- [image](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-image)
- [info](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-info)
- [memory](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-memory)
- [network](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-network)
- [network_summary](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-docker-network_summary)  <applies-to>Elastic Stack: Beta</applies-to>