﻿---
title: Couchbase module
description: This module periodically fetches metrics from Couchbase servers. The default metricsets are bucket, cluster, node. The Couchbase module is tested with...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-couchbase
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Couchbase module
This module periodically fetches metrics from [Couchbase](https://www.couchbase.com/) servers. The default metricsets are `bucket`, `cluster`, `node`.

## Compatibility

The Couchbase module is tested with Couchbase 6.5.1.

## Dashboard

The Couchbase module comes with a predefined dashboard for Couchbase cluster, node, bucket specific stats. For example:
![metricbeat couchbase overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-couchbase-overview.png)

## Example configuration

The Couchbase module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: couchbase
  metricsets: ["bucket", "cluster", "node"]
  period: 10s
  hosts: ["localhost:8091"]
  enabled: true
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [bucket](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-bucket)
- [cluster](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-cluster)
- [node](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-couchbase-node)