﻿---
title: Consul module
description: This is the Hashicorp’s Consul Metricbeat module. It is still in beta and under active development to add new Metricsets and introduce enhancements. The...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-consul
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Consul module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the [Hashicorp’s Consul](https://www.consul.io) Metricbeat module. It is still in beta and under active development to add new Metricsets and introduce enhancements.

## Compatibility

The module is being tested with 1.4.2 and 1.9.3 versions of Consul.

## Dashboard

The Consul module comes with a predefined dashboard:
![metricbeat consul](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-consul.png)

## Example configuration

The Consul module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: consul
  metricsets:
  - agent
  enabled: true
  period: 10s
  hosts: ["localhost:8500"]
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [agent](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-consul-agent)  <applies-to>Elastic Stack: Beta</applies-to>