﻿---
title: CockroachDB module
description: This module periodically fetches metrics from CockroachDB. The CockroachDB status metricset is compatible with any CockroachDB version exposing metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-cockroachdb
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# CockroachDB module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/cockroachdb).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches metrics from CockroachDB.

## Compatibility

The CockroachDB `status` metricset is compatible with any CockroachDB version exposing metrics in Prometheus format.

## Dashboard

The CockroachDB module includes a predefined dashboard with overview information of the monitored servers.
![metricbeat cockroachdb overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-cockroachdb-overview.png)

## Example configuration

The CockroachDB module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: cockroachdb
  metricsets: ['status']
  period: 10s
  hosts: ['localhost:8080']

  # This module uses the Prometheus collector metricset, all
  # the options for this metricset are also available here.
  #metrics_path: /_status/vars
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-cockroachdb-status)