﻿---
title: Ceph module
description: The Ceph module collects metrics by submitting HTTP GET requests to the ceph-rest-api. The default metricsets are cluster_disk, cluster_health, monitor_health,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-ceph
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Ceph module
The Ceph module collects metrics by submitting HTTP GET requests to the [ceph-rest-api](https://docs.ceph.com/docs/jewel/man/8/ceph-rest-api/). The default metricsets are `cluster_disk`, `cluster_health`, `monitor_health`, `pool_disk`, `osd_tree`.
Metricsets connecting to the Ceph REST API uses by default the service exposed on port 5000. Metricsets using the Ceph Manager Daemon communicate with the API exposed by default on port 8003 (SSL encryption).

## Compatibility

The Ceph module is tested with Ceph Jewel (10.2.10) and Ceph Nautilus (14.2.7).
Metricsets with the `mgr_` prefix are compatible with Ceph releases using the Ceph Manager Daemon.

## Dashboard

The Ceph module comes with a predefined dashboard showing Ceph cluster related metrics. For example:
![ceph overview dashboard](https://www.elastic.co/docs/reference/beats/metricbeat/images/ceph-overview-dashboard.png)

## Example configuration

The Ceph module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
# Metricsets depending on the Ceph REST API (default port: 5000)
- module: ceph
  metricsets: ["cluster_disk", "cluster_health", "monitor_health", "pool_disk", "osd_tree"]
  period: 10s
  hosts: ["localhost:5000"]
  enabled: true

# Metricsets depending on the Ceph Manager Daemon (default port: 8003)
- module: ceph
  metricsets:
    - mgr_cluster_disk
    - mgr_osd_perf
    - mgr_pool_disk
    - mgr_osd_pool_stats
    - mgr_osd_tree
  period: 1m
  hosts: [ "https://localhost:8003" ]
  #username: "user"
  #password: "secret"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [cluster_disk](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-cluster_disk)
- [cluster_health](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-cluster_health)
- [cluster_status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-cluster_status)
- [mgr_cluster_disk](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_cluster_disk)  <applies-to>Elastic Stack: Beta</applies-to>
- [mgr_cluster_health](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_cluster_health)  <applies-to>Elastic Stack: Beta</applies-to>
- [mgr_osd_perf](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_osd_perf)  <applies-to>Elastic Stack: Beta</applies-to>
- [mgr_osd_pool_stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_osd_pool_stats)  <applies-to>Elastic Stack: Beta</applies-to>
- [mgr_osd_tree](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_osd_tree)  <applies-to>Elastic Stack: Beta</applies-to>
- [mgr_pool_disk](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-mgr_pool_disk)  <applies-to>Elastic Stack: Beta</applies-to>
- [monitor_health](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-monitor_health)
- [osd_df](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-osd_df)
- [osd_tree](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-osd_tree)
- [pool_disk](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ceph-pool_disk)