﻿---
title: Benchmark module
description: The benchmark module is used to generate synthetic metrics at a predictable rate.  This can be useful when you want to test output settings or test system...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-benchmark
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Benchmark module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/manage-data/ingest/tools).
  </dropdown>
</admonition>

The `benchmark` module is used to generate synthetic metrics at a predictable rate.  This can be useful when you want to test output settings or test system sizing without using real data.
The `benchmark` module metricset is `info`.
```yaml
- module: benchmark
  metricsets:
    - info
  enabled: true
  period: 10s
```


## Metricsets


### `info`

A metric that includes a `counter` field which is used to keep the metric unique.

### Module-specific configuration notes

<definitions>
  <definition term="count">
    number, the number of metrics to emit per fetch.
  </definition>
</definitions>


## Example configuration

The Benchmark module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: benchmark
  metricsets:
    - info
  enabled: false
  period: 10s
```


## Metricsets

The following metricsets are available:
- [info](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-benchmark-info)  <applies-to>Elastic Stack: Beta</applies-to>