﻿---
title: Beat module
description: The beat module collects metrics about any Beat or other software based on libbeat. The beat module works with Beats 7.3.0 and later. The beat module...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-beat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Beat module
The `beat` module collects metrics about any Beat or other software based on libbeat.

## Compatibility

The `beat` module works with Beats 7.3.0 and later.

## Usage for Elastic Stack Monitoring

The `beat` module can be used to collect metrics shown in our Stack Monitoring UI in Kibana. To enable this usage, set `xpack.enabled: true` and remove any `metricsets` from the module’s configuration. Alternatively, run `metricbeat modules disable beat` and `metricbeat modules enable beat-xpack`.
<note>
  When this module is used for Elastic Stack Monitoring, it sends metrics to the monitoring index instead of the default index typically used by Metricbeat. For more details about the monitoring index, see [Configuring indices for monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring).
</note>


## Example configuration

The Beat module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: beat
  metricsets:
    - stats
    - state
  period: 10s
  hosts: ["http://localhost:5066"]
  #ssl.certificate_authorities: ["/etc/pki/root/ca.pem"]

  # Set to true to send data collected by module to X-Pack
  # Monitoring instead of metricbeat-* indices.
  #xpack.enabled: false
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [state](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-beat-state)
- [stats](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-beat-stats)