﻿---
title: Apache module
description: This module periodically fetches metrics from Apache HTTPD servers. The default metricset is status. The Apache metricsets were tested with Apache 2.4.12...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-apache
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Apache module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/apache).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches metrics from [Apache HTTPD](https://httpd.apache.org/) servers. The default metricset is `status`.

## Compatibility

The Apache metricsets were tested with Apache 2.4.12 and 2.4.54 and are expected to work with all versions >= 2.2.31 and >= 2.4.16.

## Dashboard

The Apache module comes with a predefined dashboard. For example:
![apache httpd server status](https://www.elastic.co/docs/reference/beats/metricbeat/images/apache_httpd_server_status.png)

## Example configuration

The Apache module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: apache
  metricsets: ["status"]
  period: 10s
  enabled: true

  # Apache hosts
  hosts: ["http://127.0.0.1"]

  # Path to server status. Default server-status
  #server_status_path: "server-status"

  # Username of hosts.  Empty by default
  #username: username

  # Password of hosts. Empty by default
  #password: password
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl). It also supports the options described in [Standard HTTP config options](/docs/reference/beats/metricbeat/configuration-metricbeat#module-http-config-options).

## Metricsets

The following metricsets are available:
- [status](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-apache-status)