﻿---
title: Airflow module
description: This module collects metrics from Airflow metrics. It runs a statsd server where airflow will send metrics to. The default metricset is statsd. The Airflow...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-airflow
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Airflow module
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This module collects metrics from [Airflow metrics](https://airflow.apache.org/docs/apache-airflow/stable/logging-monitoring/metrics.html). It runs a statsd server where airflow will send metrics to. The default metricset is `statsd`.

## Compatibility

The Airflow module is tested with Airflow 2.1.0. It should work with version 2.0.0 and later.

## Usage

The Airflow module requires [Statsd](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-statsd) to receive statsd metrics. Refer to the link for instructions about how to use statsd.
Add the following lines to your Airflow configuration file e.g. `airflow.cfg` ensuring `statsd_prefix` is left empty and replace `%METRICBEAT_HOST%` with the address where metricbeat is running:
```
[metrics]
statsd_on = True
statsd_host = %METRICBEAT_HOST%
statsd_port = 8126
statsd_prefix =
```


## Example configuration

The Airflow module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: airflow
  host: "localhost"
  port: "8126"
  #ttl: "30s"
  metricsets: [ 'statsd' ]
```


## Metricsets

The following metricsets are available:
- [statsd](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-airflow-statsd)  <applies-to>Elastic Stack: Beta</applies-to>