﻿---
title: Aerospike module
description: The Aerospike module uses the Info command to collect metrics. The default metricset is namespace. The Aerospike metricsets were tested with Aerospike...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-aerospike
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Aerospike module
The Aerospike module uses the [Info command](http://www.aerospike.com/docs/reference/info) to collect metrics. The default metricset is `namespace`.

## Compatibility

The Aerospike metricsets were tested with Aerospike Enterprise Edition 7.2.0.1 and are expected to work with all versions >= 4.9.

## Dashboard

The Aerospike module comes with a predefined dashboard for Aerospike namespace, node specific stats. For example:
![metricbeat aerospike overview](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-aerospike-overview.png)

## Example configuration

The Aerospike module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: aerospike
  metricsets: ["namespace"]
  enabled: true
  period: 10s
  hosts: ["localhost:3000"]

  # Aerospike Cluster Name
  #cluster_name: myclustername

  # Username of hosts. Empty by default.
  #username: root

  # Password of hosts. Empty by default.
  #password: secret

  # Authentication modes: https://aerospike.com/docs/server/guide/security/access-control
  # Possible values: internal (default), external, pki
  #auth_mode: internal

  # Optional SSL/TLS (disabled by default)
  #ssl.enabled: true

  # List of root certificates for SSL/TLS server verification
  #ssl.certificate_authorities: ["/etc/pki/root/ca.crt"]

  # Certificate for SSL/TLS client authentication
  #ssl.certificate: "/etc/pki/client/cert.crt"

  # Client certificate key file
  #ssl.key: "/etc/pki/client/cert.key"
```

This module supports TLS connections when using `ssl` config field, as described in [SSL](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl).

## Metricsets

The following metricsets are available:
- [namespace](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-aerospike-namespace)