﻿---
title: ActiveMQ module
description: This module periodically fetches JMX metrics from Apache ActiveMQ. The module has been tested with ActiveMQ 5.13.0 and 5.15.9. Other versions are expected...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-activemq
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ActiveMQ module
<admonition title="Prefer to use Elastic Agent for this use case?">
  Refer to the [Elastic Integrations documentation](https://www.elastic.co/docs/reference/integrations/activemq).
  <dropdown title="Learn more">
    Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. Refer to the documentation for a detailed [comparison of Beats and Elastic Agent](https://www.elastic.co/docs/reference/fleet).
  </dropdown>
</admonition>

This module periodically fetches JMX metrics from Apache ActiveMQ.

## Compatibility

The module has been tested with ActiveMQ 5.13.0 and 5.15.9. Other versions are expected to work.

## Usage

The ActiveMQ module requires [Jolokia](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-jolokia) to fetch JMX metrics. Refer to the link for instructions about how to use Jolokia.

## Example configuration

The ActiveMQ module supports the standard configuration options that are described in [Modules](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat). Here is an example configuration:
```yaml
metricbeat.modules:
- module: activemq
  metricsets: ['broker', 'queue', 'topic']
  period: 10s
  hosts: ['localhost:8161']
  path: '/api/jolokia/?ignoreErrors=true&canonicalNaming=false'
  username: admin
  password: admin
```


## Metricsets

The following metricsets are available:
- [broker](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-activemq-broker)
- [queue](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-activemq-queue)
- [topic](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-activemq-topic)