﻿---
title: ZooKeeper server metricset
description: server Metricset fetches the data returned by the srvr admin keyword. zookeeper.server.connections: Connections established by the server, zookeeper.server.latency.avg:...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-zookeeper-server
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ZooKeeper server metricset
`server` Metricset fetches the data returned by the `srvr` admin keyword.
- `zookeeper.server.connections`: Connections established by the server
- `zookeeper.server.latency.avg`: Average latency of the server
- `zookeeper.server.latency.max`: Max latency reached by the server
- `zookeeper.server.latency.min`: Minimum latency that has been reached by the server
- `zookeeper.server.mode`: Server mode
- `zookeeper.server.node_count`: Total number of nodes
- `zookeeper.server.outstanding`: Outstanding
- `zookeeper.server.received`: Received requests to the server
- `zookeeper.server.sent`: Requests sent by the server
- `zookeeper.server.version_date`: Date of the Zookeeper release in use
- `zookeeper.server.zxid`: Original value of the Zookeeper transaction ID
- `zookeeper.server.count`: Total transactions of the leader in epoch
- `zookeeper.server.epoch`: Epoch value of the Zookeeper transaction ID

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-zookeeper) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "zookeeper.server",
        "duration": 115000,
        "module": "zookeeper"
    },
    "metricset": {
        "name": "server",
        "period": 10000
    },
    "service": {
        "address": "192.168.176.2:2181",
        "node": {
            "name": "0"
        },
        "type": "zookeeper",
        "version": "3.5.5-390fe37ea45dee01bf87dc1c042b5e3dcce88653"
    },
    "zookeeper": {
        "server": {
            "connections": 1,
            "count": 0,
            "epoch": 0,
            "latency": {
                "avg": 0,
                "max": 0,
                "min": 0
            },
            "mode": "standalone",
            "node_count": 5,
            "outstanding": 0,
            "received": 40,
            "sent": 39,
            "version_date": "2019-05-03T12:07:00Z",
            "zxid": "0x0"
        }
    }
}
```