﻿---
title: ZooKeeper mntr metricset
description: mntr Metricset fetches the data returned by the mntr admin keyword. It exposes the following metrics: zookeeper.mntr.approximate_data_size: Approximate...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-zookeeper-mntr
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# ZooKeeper mntr metricset
`mntr` Metricset fetches the data returned by the `mntr` admin keyword. It exposes the following metrics:
- `zookeeper.mntr.approximate_data_size`: Approximate size of ZooKeeper data.
- `zookeeper.mntr.latency.avg`: Average latency between ensemble hosts in milliseconds.
- `zookeeper.mntr.ephemerals_count`: Number of ephemeral znodes.
- `zookeeper.mntr.followers`: Number of followers seen by the current host.
- `zookeeper.mntr.max_file_descriptor_count`: Maximum number of file descriptors allowed for the ZooKeeper process.
- `zookeeper.mntr.latency.max`: Maximum latency in milliseconds.
- `zookeeper.mntr.latency.min`: Minimum latency in milliseconds.
- `zookeeper.mntr.num_alive_connections`: Number of connections to ZooKeeper that are currently alive.
- `zookeeper.mntr.open_file_descriptor_count`: Number of file descriptors open by the ZooKeeper process.
- `zookeeper.mntr.outstanding_requests`: Number of outstanding requests that need to be processed by the cluster.
- `zookeeper.mntr.packets.received`: Number of ZooKeeper network packets received.
- `zookeeper.mntr.packets.sent`: Number of ZooKeeper network packets sent.
- `zookeeper.mntr.pending_syncs`: Number of pending syncs to carry out to ZooKeeper ensemble followers.
- `zookeeper.mntr.server_state`: Role in the ZooKeeper ensemble.
- `zookeeper.mntr.synced_followers`: Number of synced followers reported when a node server_state is leader.
- `zookeeper.mntr.version`: Version and build string reported.
- `zookeeper.mntr.watch_count`: Number of watches currently set on the local ZooKeeper process.
- `zookeeper.mntr.znode_count`: Number of znodes reported by the local ZooKeeper process.

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-zookeeper) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "zookeeper.mntr",
        "duration": 115000,
        "module": "zookeeper"
    },
    "metricset": {
        "name": "mntr",
        "period": 10000
    },
    "service": {
        "address": "192.168.176.2:2181",
        "node": {
            "name": "0"
        },
        "type": "zookeeper",
        "version": "3.5.5-390fe37ea45dee01bf87dc1c042b5e3dcce88653, built on 05/03/2019 12:07 GMT"
    },
    "zookeeper": {
        "mntr": {
            "approximate_data_size": 44,
            "ephemerals_count": 0,
            "latency": {
                "avg": 0,
                "max": 0,
                "min": 0
            },
            "max_file_descriptor_count": 1048576,
            "num_alive_connections": 1,
            "open_file_descriptor_count": 49,
            "outstanding_requests": 0,
            "packets": {
                "received": 34,
                "sent": 33
            },
            "server_state": "standalone",
            "watch_count": 0,
            "znode_count": 5
        }
    }
}
```