﻿---
title: Windows wmi metricset
description: The wmi metricset of the Windows module reads metrics via Windows Management Instrumentation (WMI), a core management technology in the Windows Operating...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-wmi
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta since 9.1
---

# Windows wmi metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The `wmi` metricset of the Windows module reads metrics via [Windows Management Instrumentation](https://learn.microsoft.com/en-us/windows/win32/wmisdk/about-wmi) (WMI), a core management technology in the Windows Operating system.
By leveraging WMI Query Language (WQL), this metricset allows you to extract detailed system information and metrics to monitor the health and performance of Windows Systems.
This metricset leverages the [Microsoft WMI](https://github.com/microsoft/wmi) library, a convenient wrapper around the [GO-OLE](https://github.com/go-ole) library which allows to invoke the WMI API.

## WMI Query Language (WQL) Support

This metricset supports the execution of
[WQL](https://learn.microsoft.com/en-us/windows/win32/wmisdk/wql-sql-for-wmi)
queries, a SQL-like query language for retrieving information from WMI
namespaces.
Currently, the metricset supports queries with `SELECT`, `FROM` and
`WHERE` clauses.
<warning>
  When working with WMI queries, it is the user's responsibility to ensure
  that queries are safe, efficient, and do not cause unintended side
  effects. A notorious example of a problematic WMI class is
  `Win32_Product`. Read more in the related [Windows
  documentation](https://learn.microsoft.com/en-us/troubleshoot/windows-server/admin-development/windows-installer-reconfigured-all-applications#more-information).
</warning>


## WMI Arbitrator and Query Execution

Query execution is managed by the underlying WMI Framework, specifically
the [WMI
Arbitrator](https://learn.microsoft.com/en-us/troubleshoot/windows-server/system-management-components/new-wmi-arbitrator-behavior-in-windows-server).
The Arbitrator is responsible for:
- Scheduling and controlling query execution
- Throttling or stopping queries based on system resource availability
  and conditions

There is no way to directly stop a query once it has started. To prevent
Metricbeat from waiting indefinitely for a query to return a result or
fail, Metricbeat has a timeout mechanism that stops waiting for query
results after a specified timeout. This is controlled by the
`wmi.warning_threshold` setting.
<note>
  While Metricbeat stops waiting for the result, the underlying WMI query
  may continue running until the WMI Arbitrator decides to stop execution.
</note>


## WMI Type support

The `microsoft/wmi` library internally uses the WMI Scripting API. This API, as per the
[official WMI Documentation](https://learn.microsoft.com/en-us/windows/win32/wmisdk/querying-wmi),
does not provide direct type conversion for `uint64`, `sint64`, and `datetime`
[Common Information Model](https://learn.microsoft.com/en-us/windows/win32/wmisdk/common-information-model) (CIM) types;
instead, these values are returned as strings.
To ensure the correct data type is reported, Metricbeat dynamically fetches the
CIM type definitions for the properties of the WMI instance classes returned by the query,
and then performs the necessary data type conversions.
To optimize performance and avoid repeatedly fetching these schema definitions
for every row and every request, an LRU cache is utilized. This cache stores
the schema definition for each WMI class-property pair encountered. For queries involving
superclasses, such as `CIM_LogicalDevice`, the cache will populate with individual entries
for each specific derived class (leaf of the class hierarchy) whose instances are returned by the query (for example, `Win32_DiskDrive` or `Win32_NetworkAdapter`).
<note>
  The properties of type `CIM_Object` (embedded objects) are not yet supported and are ignored.
</note>

<note>
  Properties of type `CIM_Reference` (references), which are used in [WMI Association Classes](https://learn.microsoft.com/en-us/windows/win32/wmisdk/declaring-an-association-class), are currently returned as string values exactly as reported by the [Microsoft WMI](https://github.com/microsoft/wmi) library.
</note>


## Configuration

```yaml
- module: windows
  metricsets: ["wmi"]
  period: 10m
  wmi:
    namespace: "root\\cimv2"
    warning_threshold: 10m
    include_queries: true
    include_null_properties: false
    include_empty_strings_properties: false
    max_rows_per_query: 100
    queries:
    - class: Win32_OperatingSystem
      properties:
      - FreePhysicalMemory
      - FreeSpaceInPagingFiles
      - NumberOfUsers
      where: ""
    - class: Win32_PowerPlan
      properties: []
      where: "IsActive = True"
      namespace: "root\\cimv2\\power"
```

<definitions>
  <definition term="wmi.namespace">
    The default WMI namespace used for queries. This can be overridden per
    query. The default is `"root\\cimv2"`.
  </definition>
  <definition term="wmi.warning_threshold">
    The time threshold after which Metricbeat will stop waiting for the
    query result and return control to the main flow of the program. A
    warning is logged indicating that the query execution has exceeded the
    threshold. The default is equal to the module's period. See [WMI Arbitrator and
    Query Execution](#wmi-arbitrator-and-query-execution) for more details.
  </definition>
  <definition term="wmi.include_query_class">
    If set to `true` the metricset includes the queried class.
    This is useful if superclasses are queried. The default value is `false`.
  </definition>
  <definition term="wmi.include_queries">
    If set to `true` the metricset includes the query in the output
    document. The default value is `false`.
  </definition>
  <definition term="wmi.include_null_properties">
    If set to `true` the metricset includes the properties that have null
    value in the output document. The default value is `false`.
  </definition>
  <definition term="wmi.include_empty_string_properties">
    A boolean option that causes the metricset to include the properties
    that are empty string. The default value is `false`.
  </definition>
  <definition term="wmi.max_rows_per_query">
    Limits the number of rows returned by a single WMI query.
    The default value is `0`, which is a special value indicating that all fetched
    results should be returned without a row limit.
  </definition>
  <definition term="wmi.schema_cache_size">
    The maximum number of WMI class-property pairs that can be cached per single query. Every query keeps its own separate cache.
    This cache helps improve performance when dealing with queries that involve inheritance hierarchies. Read more in [WMI Type Support](#wmi-type-support). For example, if a superclass is queried, the cache stores entries for each WMI concrete instance class (the leaves of the class hierarchy) and their associated properties. Therefore, querying a superclass that returns a result set containing instances of `10` different classes, each with `50` properties, will result in a cache size of `500` entries (`10×50`).
    The default value is `1000`.
  </definition>
  <definition term="wmi.queries">
    The list of queries to execute. The list cannot be empty. See [Query
    Configuration](#query-configuration) for the format of the queries.
  </definition>
</definitions>


### Query Configuration

Each item in the `queries` list specifies a WMI query to perform.
<definitions>
  <definition term="class">
    The WMI class. In the query it specifies the `FROM` clause. Required
  </definition>
  <definition term="properties">
    List of properties to return. In the query it specifies the `SELECT`
    clause. Set it to the empty list (default value) to retrieve all
    available properties.
  </definition>
  <definition term="where">
    The where clause. In the query it specifies the `WHERE` clause. Read
    more about the format [in the Windows
    Documentation](https://learn.microsoft.com/en-us/windows/win32/wmisdk/where-clause).
  </definition>
  <definition term="namespace">
    The WMI Namespace for this particular query (it overwrites the
    metricset’s `namespace` value)
  </definition>
</definitions>


#### Example

Example WQL Query:
```sql
SELECT Name, ProcessId, WorkingSetSize
FROM Win32_Process
WHERE Name = 'lsass.exe' AND WorkingSetSize > 104857600
```

Equivalent YAML Configuration:
```yaml
- class: Win32_Process
  properties:
  - Name
  - ProcessId
  - WorkingSetSize
  where: "Name = 'lsass.exe' AND WorkingSetSize > 104857600"
```


## Best Practices

- Test your WMI queries in isolation using the [`Get-CimInstance`](https://learn.microsoft.com/en-us/powershell/module/cimcmdlets/get-ciminstance) PowerShell cmdlet or [the WMI Explorer tool](https://github.com/vinaypamnani/wmie2).
- Ensure that `wmi.warning_threshold` is less than or equal to the module's `period`. This configuration prevents Metricbeat from attempting to start multiple concurrent executions of the same query if a previous one is running slowly.
- When possible, try querying concrete (leaf) classes or classes closer to the leaves of the WMI inheritance hierarchy. Querying abstract superclasses may require fetching and caching the schema definitions for numerous derived classes, which can lead to increased memory usage and potential performance penalties due to cache misses.
- Set up Kibana Alerts for documents generated by this metricset with the `error.message` field.
- Configure collection of WMI-Activity Operational Logs (found in Event Viewer under `Applications and Services Logs/Microsoft/Windows/WMI-Activity/Operational`). These logs can be invaluable for correlating issues with Metricbeat WMI warnings or documents containing `error.message`.


## Compatibility

This module has been tested on the following platforms:

| Operating System                         | Architecture |
|------------------------------------------|--------------|
| Microsoft Windows Server 2019 Datacenter | x64          |
| Microsoft Windows 11 Pro                 | x64          |

Other Windows versions and architectures may also work but have not been
explicitly tested.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-windows) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2024-12-12T15:46:39.622Z",
    "event": {
        "dataset": "windows.wmi",
        "duration": 58982500,
        "module": "windows"
    },
    "metricset": {
        "name": "wmi",
        "period": 10000
    },
    "service": {
        "type": "windows"
    },
    "windows": {
        "wmi": {
            "FreePhysicalMemory": 7537796,
            "FreeSpaceInPagingFiles": 2257908,
            "FreeVirtualMemory": 9694064,
            "LocalDateTime": "2024-12-12T15:46:39.62Z",
            "NumberOfUsers": 1,
            "class": "Win32_OperatingSystem",
            "namespace": "root\\cimv2"
        }
    }
}
```