﻿---
title: Windows service metricset
description: The service metricset of the Windows module reads the status of Windows services. The service metricset comes with a predefined dashboard. For example:...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-service
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Windows service metricset
The `service` metricset of the Windows module reads the status of Windows services.

## Dashboard

The service metricset comes with a predefined dashboard. For example:
![metricbeat windows service](https://www.elastic.co/docs/reference/beats/metricbeat/images/metricbeat-windows-service.png)

## Configuration

```yaml
- module: windows
  metricsets: ["service"]
  period: 60s
```


## Filtering

Processors can be used to filter the events based on the service states or their names. The example below configures the metricset to drop all events except for the events for the firewall service. See [Processors](https://www.elastic.co/docs/reference/beats/metricbeat/filtering-enhancing-data) for more information about using processors.
```yaml
- module: windows
  metricsets: ["service"]
  period: 60s
  processors:
    - drop_event.when.not.equals:
        windows.service.display_name: Windows Firewall
```


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-windows) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "windows.service",
        "duration": 115000,
        "module": "windows"
    },
    "metricset": {
        "name": "service"
    },
    "service": {
        "type": "windows"
    },
    "windows": {
        "service": {
            "display_name": "Servicio de enrutador de AllJoyn",
            "exit_code": "ERROR_SERVICE_NEVER_STARTED",
            "id": "IOQgaoSLJ7",
            "name": "AJRouter",
            "start_type": "Manual (Triggered)",
            "state": "Stopped"
        }
    }
}
```