﻿---
title: Windows perfmon metricset
description: The perfmon metricset of the Windows module reads Windows performance counters. You must configure queries for the Windows performance counters that you...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-windows-perfmon
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Windows perfmon metricset
The `perfmon` metricset of the Windows module reads Windows performance counters.

## Configuration

You must configure queries for the Windows performance counters that you wish to collect. The example below collects processor time and disk writes every 10 seconds. If either of the counters do not exist it will ignore the error.
```yaml
- module: windows
  metricsets: [perfmon]
  period: 10s
  perfmon.ignore_non_existent_counters: true
  perfmon.group_measurements_by_instance: true
  perfmon.queries:
  - object: "Process"
    instance: ["svchost*", "conhost*"]
    counters:
    - name: "% Processor Time"
      field: time.processor.pct
      format: "float"
    - name: "Thread Count"
      field: thread_count
    - name: "IO Read Operations/sec"
  - object: "PhysicalDisk"
    field : "disk"
    instance: "*"
    counters:
    - name: "Disk Writes/sec"
    - name: "% Disk Write Time"
      field: "write_time"
      format: "float"
```

<definitions>
  <definition term="ignore_non_existent_counters">
    A boolean option that causes the metricset to ignore errors caused by counters that do not exist when set to true. Instead of an error, a message will be logged at the info level stating that the counter does not exist.
  </definition>
  <definition term="group_measurements_by_instance">
    A boolean option that causes metricbeat to send all measurements with a matching perfmon instance as part of a single event. In the above example, this will cause the physical_disk.write.per_sec and physical_disk.write.time.pct measurements to be sent as a single event. The default behaviour is for all measurements to be sent as separate events.
  </definition>
  <definition term="refresh_wildcard_counters">
    A boolean option to refresh the counter list at each fetch. By default, the counter list will be retrieved at the starting time, to refresh the list at each fetch, users will have to enable this setting.
  </definition>
  <definition term="match_by_parent_instance">
    A boolean option that causes all instances of the same parent to have the same instance value. In the previous example, this causes metrics for `svchost`, `svchost#1`, and so on to have an `instance`
    value of `svchost`. If set to `false` they keep the original values (`svchost`, `svchost#1`, and so on). Defaults to `true`.
  </definition>
</definitions>


### Query Configuration

Each item in the `query` list specifies multiple perfmon queries to perform. In the events generated by the metricset these configuration options map to the field values as shown below.
<definitions>
  <definition term="object">
    The performance object to query. A performance object can be a physical component, such as processors, disks, and memory, or a system object, such as processes and threads. Required
  </definition>
  <definition term="field">
    The object field/label. Not required, if not entered, it will be `object`.
  </definition>
  <definition term="instance">
    Matches the ParentInstance, ObjectInstance, and InstanceIndex are included in the path if multiple instances of the object can exist. Not required for performance counters which do not contain one.
  </definition>
  <definition term="counters">
    List of the partial counter paths (At least one partial counter path is required).
  </definition>
  <definition term="name">
    The counter name. Required. This is the counter specified in Performance Data Helper (PDH) syntax. For example in case of the counter path `\Processor Information(_Total)\% Processor Time`, the value for this configuration option will be `% Processor Time`.
  </definition>
  <definition term="field">
    The counter path value field/label. Not required, if not entered, it will be generated based on the counter path.
  </definition>
  <definition term="format">
    Format of the measurement value. The value can be either `float`, `large` or `long`. The default is `float`.
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-windows) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "windows.perfmon",
        "duration": 115000,
        "module": "windows"
    },
    "metricset": {
        "name": "perfmon",
        "period": 10000
    },
    "service": {
        "type": "windows"
    },
    "windows": {
        "perfmon": {
            "instance": "_Total",
            "metrics": {
                "processor": {
                    "time": {
                        "total": {
                            "pct": 6.310940413107646
                        }
                    }
                }
            },
            "object": "Processor Information"
        }
    }
}
```