﻿---
title: vSphere cluster metricset
description: This is the cluster metricset of the vSphere module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-vsphere-cluster
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# vSphere cluster metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the `cluster` metricset of the vSphere module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-vsphere) section.
Here is an example document generated by this metricset:
```json
{
  "@timestamp": "2017-10-12T08:05:34.853Z",
  "event": {
      "dataset": "vsphere.cluster",
      "duration": 115000,
      "module": "vsphere"
  },
  "metricset": {
      "name": "cluster",
      "period": 10000
  },
  "service": {
      "address": "127.0.0.1:33365",
      "type": "vsphere"
  },
  "vsphere": {
      "cluster": {
          "triggered_alarms": [
              {
                  "status": "red",
                  "triggered_time": "2024-09-09T13:23:00.786Z",
                  "description": "Default alarm to monitor system boards.  See the host's Hardware Status tab for more details.",
                  "entity_name": "121.0.0.0",
                  "name": "Host hardware system board status",
                  "id": "alarm-121.host-12"
              },
              {
                  "triggered_time": "2024-09-09T13:23:00.786Z",
                  "description": "Default alarm to monitor storage.  See the host's Hardware Status tab for more details.",
                  "entity_name": "121.0.0.0",
                  "name": "Host storage status",
                  "id": "alarm-124.host-12",
                  "status": "red"
              },
              {
                  "entity_name": "121.0.0.0",
                  "name": "Host memory usage",
                  "id": "alarm-4.host-12",
                  "status": "yellow",
                  "triggered_time": "2024-08-28T10:31:26.621Z",
                  "description": "Default alarm to monitor host memory usage"
              },
              {
                  "name": "CPU Utilization",
                  "id": "alarm-703.host-12",
                  "status": "red",
                  "triggered_time": "2024-08-28T10:31:26.621Z",
                  "description": "",
                  "entity_name": "121.0.0.0"
              }
          ],
          "id": "domain-c1",
          "name": "Cluster_1",
          "das_config": {
              "enabled": false,
              "admission": {
                  "control": {
                      "enabled": true
                  }
              }
          },
          "host": {
              "count": 1,
              "names": [
                  "Host_1"
              ]
          },
          "datastore": {
              "count": 1,
              "names": [
                  "Datastore_1"
              ]
          },
          "network": {
              "count": 1,
              "names": [
                  "Network_1"
              ]
          }
      }
  }
}
```