﻿---
title: uWSGI status metricset
description: This module periodically fetches metrics from uWSGI servers. The uWSGI metricsets were tested with uWSGI 2.0.15 and are expected to work with all version...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-uwsgi-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# uWSGI status metricset
This module periodically fetches metrics from [uWSGI](http://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html) servers.

## Compatibility

The uWSGI metricsets were tested with uWSGI 2.0.15 and are expected to work with all version >= 1.4.9
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-uwsgi) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "uwsgi.status",
        "duration": 115000,
        "module": "uwsgi"
    },
    "metricset": {
        "name": "status",
        "period": 10000
    },
    "service": {
        "address": "172.28.0.3:9191",
        "type": "uwsgi"
    },
    "uwsgi": {
        "status": {
            "total": {
                "exceptions": 0,
                "pid": 1,
                "read_errors": 0,
                "requests": 2,
                "write_errors": 0
            }
        }
    }
}
```