﻿---
title: Tomcat threading metricset
description: Threading Metricset retrieves the JMX key Catalina:name=*,type=ThreadPool and java.lang:type=Threading using Jolokia. It exposes the following metrics:...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-threading
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Tomcat threading metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Threading Metricset retrieves the JMX key `Catalina:name=*,type=ThreadPool` and `java.lang:type=Threading` using Jolokia. It exposes the following metrics:
- `tomcat.threading.busy`: Current busy threads from the ThreadPool
- `tomcat.threading.max`: Max threads from the ThreadPool
- `tomcat.threading.current`: Current number of threads, taken from the ThreadPool
- `tomcat.threading.keep_alive.total`: Total keep alive on the ThreadPool
- `tomcat.threading.keep_alive.timeout.ms`: Keep alive timeout on the ThreadPool
- `tomcat.threading.started.total`: Current started threads at JVM level (from java.lang:type=Threading)
- `tomcat.threading.user.time.ms`: User time in milliseconds (from java.lang:type=Threading)
- `tomcat.threading.cpu.time.ms`: CPU time in milliseconds (from java.lang:type=Threading)
- `tomcat.threading.total`: Total threads at the JVM level (from java.lang:type=Threading)
- `tomcat.threading.peak`: Peak number of threads at JVM level (from java.lang:type=Threading)

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-tomcat) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-09-16T11:24:36.957Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "event": {
        "duration": 7677063,
        "dataset": "tomcat.threading",
        "module": "tomcat"
    },
    "metricset": {
        "name": "threading",
        "period": 10000
    },
    "service": {
        "type": "tomcat",
        "address": "localhost:8080"
    },
    "tomcat": {
        "threading": {
            "total": 35,
            "started": {
                "total": 35
            },
            "user": {
                "time": {
                    "ms": 6e+07
                }
            },
            "peak": 35,
            "cpu": {
                "time": {
                    "ms": 6.9719161e+07
                }
            }
        }
    },
    "ecs": {
        "version": "1.1.0"
    },
    "host": {
        "hostname": "mcastro",
        "architecture": "x86_64",
        "os": {
            "name": "Antergos Linux",
            "kernel": "5.0.13-arch1-1-ARCH",
            "platform": "antergos",
            "version": "",
            "family": ""
        },
        "id": "54f70115bae545cbac2b150f254472a0",
        "containerized": false,
        "name": "mcastro"
    },
    "agent": {
        "ephemeral_id": "a4cc9624-50c1-462c-b254-fa45896ebdfb",
        "hostname": "mcastro",
        "id": "7e36a073-1a32-4a94-b65b-4c7f971fb228",
        "version": "8.0.0",
        "type": "metricbeat"
    }
}
```