﻿---
title: Tomcat memory metricset
description: Memory Metricset retrieves the JMX key java.lang:type=Memory using Jolokia. It exposes the following metrics: tomcat.memory.heap.usage.committed: Committed...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-memory
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Tomcat memory metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Memory Metricset retrieves the JMX key `java.lang:type=Memory` using Jolokia. It exposes the following metrics:
- `tomcat.memory.heap.usage.committed`: Committed heap memory usage.
- `tomcat.memory.heap.usage.max`: Max heap memory usage.
- `tomcat.memory.heap.usage.used`: Used heap memory usage.
- `tomcat.memory.heap.usage.init`: Initial heap memory usage.
- `tomcat.memory.other.usage.committed`: Committed non-heap memory usage.
- `tomcat.memory.other.usage.max`: Max non-heap memory usage.
- `tomcat.memory.other.usage.used`: Used non-heap memory usage.
- `tomcat.memory.other.usage.init`: Initial non-heap memory usage.

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-tomcat) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-09-16T11:24:36.957Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "tomcat": {
        "memory": {
            "heap": {
                "usage": {
                    "used": 2.0846464e+07,
                    "init": 5.22190848e+08,
                    "committed": 5.22190848e+08,
                    "max": 8.338276352e+09
                }
            },
            "other": {
                "usage": {
                    "used": 3.5853392e+07,
                    "init": 7.667712e+06,
                    "committed": 3.9911424e+07,
                    "max": -1
                }
            }
        }
    },
    "ecs": {
        "version": "1.1.0"
    },
    "host": {
        "containerized": false,
        "hostname": "mcastro",
        "name": "mcastro",
        "architecture": "x86_64",
        "os": {
            "name": "Antergos Linux",
            "kernel": "5.0.13-arch1-1-ARCH",
            "platform": "antergos",
            "version": "",
            "family": ""
        },
        "id": "54f70115bae545cbac2b150f254472a0"
    },
    "agent": {
        "version": "8.0.0",
        "type": "metricbeat",
        "ephemeral_id": "a4cc9624-50c1-462c-b254-fa45896ebdfb",
        "hostname": "mcastro",
        "id": "7e36a073-1a32-4a94-b65b-4c7f971fb228"
    },
    "event": {
        "duration": 6965150,
        "dataset": "tomcat.memory",
        "module": "tomcat"
    },
    "metricset": {
        "name": "memory",
        "period": 10000
    },
    "service": {
        "address": "localhost:8080",
        "type": "tomcat"
    }
}
```