﻿---
title: Tomcat cache metricset
description: Cache Metricset retrieves the JMX key Catalina:context=*,host=*,name=Cache,type=WebResourceRoot. It exposes the following metrics: tomcat.cache.mbean:...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-tomcat-cache
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Tomcat cache metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

Cache Metricset retrieves the JMX key `Catalina:context=*,host=*,name=Cache,type=WebResourceRoot`. It exposes the following metrics:
- `tomcat.cache.mbean`: Mbean that this event is related to.
- `tomcat.cache.hit.total`: The number of requests for resources that were served from the cache.
- `tomcat.cache.size.total.kb`: The current estimate of the cache size in kB
- `tomcat.cache.size.max.kb`: The maximum permitted size of the cache in kB
- `tomcat.cache.lookup.total`: The number of requests for resources
- `tomcat.cache.ttl.ms`: The time-to-live for cache entries in milliseconds

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-tomcat) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-09-19T13:42:47.806Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "event": {
        "dataset": "tomcat.cache",
        "module": "tomcat",
        "duration": 98441554
    },
    "metricset": {
        "name": "cache",
        "period": 10000
    },
    "service": {
        "address": "localhost:8080",
        "type": "tomcat"
    },
    "tomcat": {
        "cache": {
            "mbean": "Catalina:context=/docs,host=localhost,name=Cache,type=WebResourceRoot",
            "hit": {
                "total": 4
            },
            "size": {
                "total": {
                    "kb": 5
                },
                "max": {
                    "kb": 10240
                }
            },
            "lookup": {
                "total": 13
            },
            "ttl": {
                "ms": 5000
            }
        }
    },
    "ecs": {
        "version": "1.1.0"
    },
    "host": {
        "id": "54f70115bae545cbac2b150f254472a0",
        "containerized": false,
        "hostname": "mcastro",
        "architecture": "x86_64",
        "name": "mcastro",
        "os": {
            "family": "",
            "name": "Antergos Linux",
            "kernel": "5.0.13-arch1-1-ARCH",
            "platform": "antergos",
            "version": ""
        }
    },
    "agent": {
        "version": "8.0.0",
        "type": "metricbeat",
        "ephemeral_id": "ccb9ebe2-bd8b-4d90-a362-37132e09370b",
        "hostname": "mcastro",
        "id": "7e36a073-1a32-4a94-b65b-4c7f971fb228"
    }
}
```