﻿---
title: System users metricset
description: The system/users metricset reports logged in users and associated sessions via dbus and logind, which is a systemd component. By default, the metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-users
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# System users metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The system/users metricset reports logged in users and associated sessions via dbus and logind, which is a systemd component. By default, the metricset will look in `/var/run/dbus/` for a system socket, although a new path can be selected with `DBUS_SYSTEM_BUS_ADDRESS`.
This metricset is available on:
- Linux


## Configuration

There are no configuration options for this metricset.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.users",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "users",
        "period": 10000
    },
    "process": {
        "pid": 10786
    },
    "service": {
        "type": "system"
    },
    "source": {
        "ip": "192.168.1.86"
    },
    "system": {
        "users": {
            "id": 6,
            "leader": 10786,
            "path": "/org/freedesktop/login1/session/_36",
            "remote": true,
            "remote_host": "192.168.1.86",
            "scope": "session-6.scope",
            "seat": "",
            "service": "sshd",
            "state": "active",
            "type": "tty"
        }
    },
    "user": {
        "id": "1000",
        "name": "alexk"
    }
}
```