﻿---
title: System uptime metricset
description: The System uptime metricset provides the uptime of the host operating system. This metricset is available on: Linux, macOS, OpenBSD, FreeBSD, Windows...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-uptime
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System uptime metricset
The System `uptime` metricset provides the uptime of the host operating system.
This metricset is available on:
- Linux
- macOS
- OpenBSD
- FreeBSD
- Windows


## Configuration

There are no configuration options for this metricset.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "system.uptime",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "uptime"
    },
    "service": {
        "type": "system"
    },
    "system": {
        "uptime": {
            "duration": {
                "ms": 1295582000
            }
        }
    }
}
```