﻿---
title: System socket metricset
description: This metricset is available on Linux only and requires kernel 2.6.14 or newer. The system socket metricset reports an event for each new TCP socket that...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-socket
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System socket metricset
This metricset is available on Linux only and requires kernel 2.6.14 or newer.
The system `socket` metricset reports an event for each new TCP socket that it sees. It does this by polling the kernel periodically to get a dump of all sockets. You set the polling interval by configuring the `period` option. Specifying a short polling interval with this metricset is important to avoid missing short-lived connections. For example:
```yaml
metricbeat.modules:
- module: system
  metricsets: [cpu, memory]
- module: system
  metricsets: [socket] 
  period: 1s
```

The metricset reports the process that has the socket open. To provide this information on Linux for all processes, Metricbeat must be run with `sys_ptrace` and `dac_read_search` capabilities. These permissions are usually granted when running as root, but they can and may need to be explictly added when running Metricbeat inside a container.

## Configuration

```yaml
- module: system
  metricsets: [socket]
  socket.reverse_lookup.enabled: false
  socket.reverse_lookup.success_ttl: 60s
  socket.reverse_lookup.failure_ttl: 60s
```

<definitions>
  <definition term="socket.reverse_lookup.enabled">
    You can configure the metricset to perform a reverse lookup on the remote IP, and the returned hostname will be added to the event and cached. If a hostname is found, then the eTLD+1 (effective top-level domain plus one level) value will also be added to the event. Reverse lookups are disabled by default.
  </definition>
  <definition term="socket.reverse_lookup.success_ttl">
    The results of successful reverse lookups are cached for the period of time defined by this option. The default value is 60s.
  </definition>
  <definition term="socket.reverse_lookup.failure_ttl">
    The results of failed reverse lookups are cached for the period of time defined by this option. The default value is 60s.
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "system.socket",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "socket"
    },
    "network": {
        "direction": "listening",
        "iana_number": "41",
        "type": "ipv6"
    },
    "process": {
        "args": [
            "/tmp/go-build774092237/b001/socket.test",
            "-data"
        ],
        "executable": "/tmp/go-build774092237/b001/socket.test",
        "name": "socket.test",
        "pid": 32127
    },
    "server": {
        "ip": "::",
        "port": 45109
    },
    "service": {
        "type": "system"
    },
    "system": {
        "socket": {
            "local": {
                "ip": "::",
                "port": 45109
            },
            "process": {
                "cmdline": "/tmp/go-build774092237/b001/socket.test -data"
            }
        }
    },
    "user": {
        "full_name": "Jaime Soriano Pastor",
        "id": "1000",
        "name": "jaime"
    }
}
```