﻿---
title: System ntp metricset
description: The System ntp metricset provides Network Time Protocol (NTP) metrics. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD, Windows. For a...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-ntp
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta since 9.2
---

# System ntp metricset
The System `ntp` metricset provides Network Time Protocol (NTP) metrics.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD
- Windows


## Configuration

<definitions>
  <definition term="ntp.servers">
    Remote NTP server addresses of the form "host", "host:port", "host%zone:port", "[host]:port" or "[host%zone]:port". The server may contain an IPv4, IPv6, or domain name address. When specifying both a port and an IPv6 address, one of the bracket formats must be used. If no port is included, NTP default port 123 is used. If multiple servers are specified, metrics are reported separately for each. Defaults to ["pool.ntp.org"].
  </definition>
  <definition term="ntp.timeout">
    Timeout determines how long the client waits for a response from the remote server before failing with a timeout error. Defaults to 5 seconds.
  </definition>
  <definition term="ntp.version">
    Version of the NTP protocol to use. Must be one of "3" or "4". Defaults to "4".
  </definition>
  <definition term="ntp.validate">
    Whether to validate the NTP response if it is suitable for time synchronization purposes. If not, the response will be skipped. Must be one of "true" or "false". Defaults to "true".
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "system.ntp",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "ntp"
    },
    "service": {
        "type": "system"
    },
    "system": {
        "ntp": {
            "host": "0.pool.ntp.org",
            "offset": 127140000
        }
    }
}
```