﻿---
title: System network metricset
description: The System network metricset provides network IO metrics collected from the operating system. One event is created for each network interface. This metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-network
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System network metricset
The System `network` metricset provides network IO metrics collected from the operating system. One event is created for each network interface.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- Windows


## Configuration

<definitions>
  <definition term="interfaces">
    By default metrics are reported from all network interfaces. To select which interfaces metrics are reported from, use the `interfaces` configuration option. The value must be an array of interface names. For example:
  </definition>
</definitions>

```yaml
metricbeat.modules:
- module: system
  metricsets: [network]
  interfaces: [eth0]
```

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.network",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "network",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "network": {
            "in": {
                "bytes": 2595422773,
                "dropped": 0,
                "errors": 0,
                "packets": 18264437
            },
            "name": "lo0",
            "out": {
                "bytes": 2595422773,
                "dropped": 0,
                "errors": 0,
                "packets": 18264437
            }
        }
    }
}
```