﻿---
title: System memory metricset
description: The System memory metricset provides memory statistics. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD, Windows. There are no configuration...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-memory
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System memory metricset
The System `memory` metricset provides memory statistics.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD
- Windows


## Configuration

There are no configuration options for this metricset.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.memory",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "memory",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "memory": {
            "actual": {
                "free": 59377467392,
                "used": {
                    "bytes": 3743330304,
                    "pct": 0.0593
                }
            },
            "cached": 7460179968,
            "free": 52030529536,
            "swap": {
                "free": 8589930496,
                "total": 8589930496,
                "used": {
                    "bytes": 0,
                    "pct": 0
                }
            },
            "total": 63120797696,
            "used": {
                "bytes": 11090268160,
                "pct": 0.1757
            }
        }
    }
}
```