﻿---
title: System load metricset
description: The System load metricset provides load statistics. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD. There are no configuration options...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-load
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System load metricset
The System `load` metricset provides load statistics.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD


## Configuration

There are no configuration options for this metricset.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "system.load",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "load"
    },
    "service": {
        "type": "system"
    },
    "system": {
        "load": {
            "1": 2.33,
            "15": 2.03,
            "5": 1.93,
            "cores": 4,
            "norm": {
                "1": 0.5825,
                "15": 0.5075,
                "5": 0.4825
            }
        }
    }
}
```