﻿---
title: System fsstat metricset
description: The System fsstat metricset provides overall file system statistics. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD, Windows. filesystem.ignore_types...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-fsstat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System fsstat metricset
The System `fsstat` metricset provides overall file system statistics.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD
- Windows


## Configuration

**`filesystem.ignore_types`** - A list of filesystem types to ignore. Metrics will not be collected from filesystems matching these types. This setting also affects the `filesystem` metricset. If this option is not set, metricbeat ignores all types for virtual devices in systems where this information is available (e.g. all types marked as `nodev` in `/proc/filesystems` in Linux systems).

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.fsstat",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "fsstat",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "fsstat": {
            "count": 4,
            "total_files": 781546688,
            "total_size": {
                "free": 7694209683456,
                "total": 7997223641088,
                "used": 303013957632
            }
        }
    }
}
```